package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aEsquemasXSD;

/**
 * Ab18a04s00DaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aEsquemasXSDDaoImpl implements Ab18aEsquemasXSDDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aEsquemasXSD> rwMap = new RowMapper<Ab18aEsquemasXSD>() {
		public Ab18aEsquemasXSD mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aEsquemasXSD(resultSet.getInt("T04IDESQUEMA"), resultSet.getDate("T04FECHABAJA"), resultSet.getString("T04ESQUEMA"), null,
					resultSet.getString("T04CODESQUEMA"), resultSet.getString("T04RUTA"));
		}
	};

	private RowMapper<Ab18aEsquemasXSD> rwMapPK = new RowMapper<Ab18aEsquemasXSD>() {
		public Ab18aEsquemasXSD mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aEsquemasXSD(resultSet.getInt("T04IDESQUEMA"));
		}
	};

	private RowMapper<String> rwRuta = new RowMapper<String>() {
		public String mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new String(resultSet.getString("T04RUTA"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aEsquemasXSD>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aEsquemasXSD>>() {
		public JerarquiaDto<Ab18aEsquemasXSD> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Ab18aEsquemasXSD ab18a04s00 = new Ab18aEsquemasXSD(resultSet.getInt("T04IDESQUEMA"), resultSet.getDate("T04FECHABAJA"),
					resultSet.getString("T04ESQUEMA"), resultSet.getInt("T06IDBOLETIN"), resultSet.getString("T04CODESQUEMA"), null);

			JerarquiaDto<Ab18aEsquemasXSD> jerarquia = new JerarquiaDto<Ab18aEsquemasXSD>();
			jerarquia.setModel(ab18a04s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab18a04s00 table.
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00
	 * @return Ab18a04s00
	 */
	public Ab18aEsquemasXSD add(Ab18aEsquemasXSD ab18a04s00) {
		String query = "INSERT INTO AB18A04S00 (T04_ID_ESQUEMA, T06_ID_BOLETIN, T04_FECHA_BAJA, T04_ESQUEMA) VALUES (?,?,?,?)";

		this.jdbcTemplate.update(query, ab18a04s00.getT04IdEsquema(), ab18a04s00.getT06IdBoletin(), ab18a04s00.getT04FechaBaja(),
				ab18a04s00.getT04Esquema());
		return ab18a04s00;
	}

	/**
	 * Updates a single row in the Ab18a04s00 table.
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00
	 * @return Ab18a04s00
	 */
	public Ab18aEsquemasXSD update(Ab18aEsquemasXSD ab18a04s00) {
		String query = "UPDATE AB18A04S00 SET T06_ID_BOLETIN=?, T04_FECHA_BAJA=?, T04_ESQUEMA=? WHERE T04_ID_ESQUEMA=?";

		this.jdbcTemplate.update(query, ab18a04s00.getT06IdBoletin(), ab18a04s00.getT04FechaBaja(), ab18a04s00.getT04Esquema(),
				ab18a04s00.getT04IdEsquema());
		return ab18a04s00;
	}

	/**
	 * Finds a single row in the Ab18a04s00 table.
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00
	 * @return Ab18a04s00
	 */
	@Transactional(readOnly = true)
	public Ab18aEsquemasXSD find(Ab18aEsquemasXSD ab18a04s00) {
		String query = "SELECT t1.T04_ID_ESQUEMA T04IDESQUEMA, t1.T04_FECHA_BAJA T04FECHABAJA, t1.T04_ESQUEMA T04ESQUEMA, t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN, t2.T06_DESC AB18A06S00T06DESC, t2.T06_LOGIN AB18A06S00T06LOGIN, t2.T06_PASS AB18A06S00T06PASS, t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF FROM AB18A04S00 t1 , AB18A06S00 t2  WHERE t1.T04_ID_ESQUEMA = ?   AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+)";

		List<Ab18aEsquemasXSD> ab18a04s00List = this.jdbcTemplate.query(query, this.rwMap, ab18a04s00.getT04IdEsquema());
		return (Ab18aEsquemasXSD) DataAccessUtils.uniqueResult(ab18a04s00List);
	}

	/**
	 * Removes a single row in the Ab18a04s00 table.
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00
	 * @return
	 */
	public void remove(Ab18aEsquemasXSD ab18a04s00) {
		String query = "DELETE FROM AB18A04S00 WHERE T04_ID_ESQUEMA=?";
		this.jdbcTemplate.update(query, ab18a04s00.getT04IdEsquema());
	}

	/**
	 * Finds a list of rows in the Ab18a04s00 table.
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a04s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aEsquemasXSD> findAll(Ab18aEsquemasXSD ab18a04s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T04_ID_ESQUEMA T04IDESQUEMA,t1.T04_FECHA_BAJA T04FECHABAJA,t1.T04_COD_ESQUEMA T04CODESQUEMA, t1.T04_ESQUEMA T04ESQUEMA,t1.T04_VERSION_ESQUEMA T04RUTA ");
		query.append("FROM AB18A04S00 t1 ,AB18A06S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a04s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aEsquemasXSD>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a04s00 table using like.
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a04s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aEsquemasXSD> findAllLike(Ab18aEsquemasXSD ab18a04s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T04_ID_ESQUEMA T04IDESQUEMA,t1.T04_FECHA_BAJA T04FECHABAJA,t1.T04_ESQUEMA T04ESQUEMA,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		query.append("FROM AB18A04S00 t1 ,AB18A06S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a04s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aEsquemasXSD>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a04s00 table.
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aEsquemasXSD ab18a04s00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A04S00 t1 , AB18A06S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a04s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Ab18a04s00 table using like.
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aEsquemasXSD ab18a04s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A04S00 t1 ,AB18A06S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a04s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a04s00 selected for rup_table
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a04s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aEsquemasXSD>> reorderSelection(Ab18aEsquemasXSD ab18a04s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T04_ID_ESQUEMA T04IDESQUEMA,t1.T04_FECHA_BAJA T04FECHABAJA,t1.T04_ESQUEMA T04ESQUEMA,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		// FROM
		query.append("FROM AB18A04S00 t1 ,AB18A06S00 t2 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a04s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(query, jqGridRequestDto, Ab18aEsquemasXSD.class, filterParamList,
				"T04_ID_ESQUEMA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aEsquemasXSD>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18a04s00
	 * @param searchParams
	 *            Ab18a04s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a04s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aEsquemasXSD>> search(Ab18aEsquemasXSD filterParams, Ab18aEsquemasXSD searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T04_ID_ESQUEMA T04IDESQUEMA,t1.T04_FECHA_BAJA T04FECHABAJA,t1.T04_ESQUEMA T04ESQUEMA,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		// FROM
		query.append("FROM AB18A04S00 t1 ,AB18A06S00 t2 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Ab18aEsquemasXSD.class, filterParamList,
				searchSQL, searchParamList, from_alias, "T04_ID_ESQUEMA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aEsquemasXSD>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a04s00
	 *            Ab18a04s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aEsquemasXSD filterab18a04s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T04_ID_ESQUEMA T04IDESQUEMA,t1.T04_FECHA_BAJA T04FECHABAJA,t1.T04_ESQUEMA T04ESQUEMA,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		// FROM
		query.append("FROM AB18A04S00 t1 ,AB18A06S00 t2 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a04s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Ab18aEsquemasXSD.class, query, params,
				"T04_ID_ESQUEMA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a04s00 table.
	 * 
	 * @param filterAb18a04s00
	 *            Ab18a04s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a04s00>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aEsquemasXSD>> findAllLikeJerarquia(Ab18aEsquemasXSD filterAb18a04s00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T04_ID_ESQUEMA T04IDESQUEMA,t1.T04_FECHA_BAJA T04FECHABAJA,t1.T04_ESQUEMA T04ESQUEMA,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A04S00 t1 ,AB18A06S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A04S00");
		from.add("AB18A06S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a04s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "T04_ID_ESQUEMA", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a04s00
	 *            Ab18a04s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Ab18aEsquemasXSD filterAb18a04s00, JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A04S00 t1 ,AB18A06S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A04S00");
		from.add("AB18A06S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a04s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "T04_ID_ESQUEMA", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a04s00
	 *            Ab18a04s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a04s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aEsquemasXSD>> findAllChild(Ab18aEsquemasXSD filterAb18a04s00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A04S00 t1 ,AB18A06S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A04S00");
		from.add("AB18A06S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a04s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "T04_ID_ESQUEMA", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Ab18aEsquemasXSD>(this.rwMapPK, "T04_ID_ESQUEMA"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a04s00 entity
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aEsquemasXSD ab18a04s00) {

		StringBuilder where = new StringBuilder(Ab18aEsquemasXSDDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a04s00 != null && ab18a04s00.getT04IdEsquema() != null) {
			where.append(" AND t1.T04_ID_ESQUEMA = ?");
			params.add(ab18a04s00.getT04IdEsquema());
		}

		if (ab18a04s00 != null && ab18a04s00.getT04FechaBaja() != null) {
			where.append(" AND t1.T04_FECHA_BAJA = ?");
			params.add(ab18a04s00.getT04FechaBaja());
		}

		if (ab18a04s00 != null && ab18a04s00.getT06IdBoletin() != null) {
			where.append(" AND t1.T06_ID_BOLETIN = ?");
			params.add(ab18a04s00.getT06IdBoletin());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a04s00 entity
	 * 
	 * @param ab18a04s00
	 *            Ab18a04s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aEsquemasXSD ab18a04s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(Ab18aEsquemasXSDDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a04s00 != null && ab18a04s00.getT04IdEsquema() != null) {
			where.append(" AND t1.T04_ID_ESQUEMA = ?");
			params.add(ab18a04s00.getT04IdEsquema());
		}

		if (ab18a04s00 != null && ab18a04s00.getT04FechaBaja() != null) {
			where.append(" AND t1.T04_FECHA_BAJA = ?");
			params.add(ab18a04s00.getT04FechaBaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Transactional(readOnly = true)
	public List<String> findRutas(Ab18aEsquemasXSD ab18a04s00) {
		StringBuilder query = new StringBuilder("SELECT DISTINCT t1.T04_VERSION_ESQUEMA T04RUTA ");
		query.append("FROM AB18A04S00 t1 ,AB18A06S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a04s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<String>) this.jdbcTemplate.query(query.toString(), this.rwRuta, params.toArray());
	}
}
